##@cond
# pylint: skip-file
"""Internal module for communication with the C API of the PSTSDK.

Copyright PS-Tech B.V. All Rights Reserved.
"""
import sys
import os
import ctypes as c

def _load_pst_library():
    try:
        if sys.platform.startswith("linux"):
            return c.CDLL(os.path.dirname(os.path.abspath(__file__)) + "/lib/libpstsdk_c.so")
        elif sys.platform.startswith("win32"):
            return c.CDLL(os.path.dirname(os.path.abspath(__file__)) + "/lib/pstsdk_c.dll")
    except OSError as err:
        print(err)
        return None

_c_pstsdk = _load_pst_library()

class _CApi:
    def pst_alloc_and_get_last_error_message(self, string):
        return _c_pstsdk.pst_alloc_and_get_last_error_message(string)

    def pst_tracker_init(self, tracker):
        return _c_pstsdk.pst_tracker_init(tracker)

    def pst_tracker_init1(self, tracker, path):
        return _c_pstsdk.pst_tracker_init1(tracker, path)

    def pst_tracker_init2(self, ctracker, path, config_file):
        return _c_pstsdk.pst_tracker_init2(ctracker, path, config_file)

    def pst_tracker_init3(self, ctracker, path, config_file,  db_file):
        return _c_pstsdk.pst_tracker_init3(ctracker, path, config_file, db_file)

    def pst_tracker_init4(self, ctracker, path, config_file, db_file, grabber_name):
        return _c_pstsdk.pst_tracker_init4(ctracker, path, config_file, db_file, grabber_name)

    def pst_tracker_destroy(self, ctracker):
        _c_pstsdk.pst_tracker_destroy(ctracker)

    def pst_tracker_load_calibration_from_local_path(self, ctracker, path):
        return _c_pstsdk.pst_tracker_load_calibration_from_local_path(ctracker, path)

    def pst_tracker_get_connected_camera_urls(self, ctracker, silent, urls):
        return _c_pstsdk.pst_tracker_get_connected_camera_urls(ctracker, silent, urls)

    def pst_tracker_get_uncalibrated_camera_urls(self, ctracker, silent, urls):
        return _c_pstsdk.pst_tracker_get_uncalibrated_camera_urls(ctracker, silent, urls)

    def pst_tracker_alloc_and_get_version_info(self, ctracker, version_string):
        return _c_pstsdk.pst_tracker_alloc_and_get_version_info(ctracker, version_string)

    def pst_tracker_alloc_and_get_config_path(self, ctracker, config_path):
        return _c_pstsdk.pst_tracker_alloc_and_get_config_path(ctracker, config_path)

    def pst_tracker_get_single_measurement(self, ctracker, cdata):
        return _c_pstsdk.pst_tracker_get_single_measurement(ctracker, cdata)

    def pst_tracker_add_tracker_listener(self, ctracker, void_ptr1, void_ptr2):
        return _c_pstsdk.pst_tracker_add_tracker_callbacks(ctracker, void_ptr1, void_ptr2)

    def pst_tracker_remove_tracker_listener(self, ctracker, void_ptr1, void_ptr2):
        return _c_pstsdk.pst_tracker_remove_tracker_callbacks(ctracker, void_ptr1, void_ptr2)

    def pst_tracker_start(self, ctracker):
        return _c_pstsdk.pst_tracker_start(ctracker)

    def pst_tracker_pause(self, ctracker):
        return _c_pstsdk.pst_tracker_pause(ctracker)

    def pst_tracker_system_check(self, ctracker):
        return _c_pstsdk.pst_tracker_system_check(ctracker)

    def pst_tracker_set_framerate(self, ctracker, fps):
        return _c_pstsdk.pst_tracker_set_framerate(ctracker, fps)

    def pst_tracker_get_framerate(self, ctracker, fps):
        return _c_pstsdk.pst_tracker_get_framerate(ctracker, fps)

    def pst_tracker_alloc_and_get_supported_framerates(self, ctracker, framerates, number_of_framerates):
        return _c_pstsdk.pst_tracker_alloc_and_get_supported_framerates(ctracker, framerates, number_of_framerates)

    def pst_tracker_set_exposure(self, ctracker, time):
        return _c_pstsdk.pst_tracker_set_exposure(ctracker, time)

    def pst_tracker_get_exposure(self, ctracker, exposure):
        return _c_pstsdk.pst_tracker_get_exposure(ctracker, exposure)

    def pst_tracker_get_exposure_range(self, ctracker, min, max):
        return _c_pstsdk.pst_tracker_get_exposure_range(ctracker, min, max)

    def pst_tracker_enable_filtering(self, ctracker):
        return _c_pstsdk.pst_tracker_enable_filtering(ctracker)

    def pst_tracker_disable_filtering(self, ctracker):
        return _c_pstsdk.pst_tracker_disable_filtering(ctracker)

    def pst_tracker_set_position_filter(self, ctracker, value):
        return _c_pstsdk.pst_tracker_set_position_filter(ctracker, value)

    def pst_tracker_set_orientation_filter(self, ctracker, value):
        return _c_pstsdk.pst_tracker_set_orientation_filter(ctracker, value)

    def pst_tracker_enable_tremor_filter(self, ctracker):
        return _c_pstsdk.pst_tracker_enable_tremor_filter(ctracker)

    def pst_tracker_disable_tremor_filter(self, ctracker):
        return _c_pstsdk.pst_tracker_disable_tremor_filter(ctracker)

    def pst_tracker_enable_image_transfer(self, ctracker):
        return _c_pstsdk.pst_tracker_enable_image_transfer(ctracker)

    def pst_tracker_disable_image_transfer(self, ctracker):
        return _c_pstsdk.pst_tracker_disable_image_transfer(ctracker)

    def pst_tracker_get_pst_image(self, ctracker, image):
        return _c_pstsdk.pst_tracker_get_pst_image(ctracker, image)

    def pst_tracker_alloc_and_get_target_list(self, ctracker, statuses, number_of_statuses):
        return _c_pstsdk.pst_tracker_alloc_and_get_target_list(ctracker, statuses, number_of_statuses)

    def pst_tracker_get_target_info(self, ctracker, name, target):
        return _c_pstsdk.pst_tracker_get_target_info(ctracker, name, target)

    def pst_tracker_set_target_status(self, ctracker, name, set_active):
        return _c_pstsdk.pst_tracker_set_target_status(ctracker, name, set_active)

    def pst_tracker_get_target_status(self, ctracker, name, status):
        return _c_pstsdk.pst_tracker_get_target_status(ctracker, name, status)

    def pst_tracker_get_target_markers(self, ctracker, name, marker_list):
        return _c_pstsdk.pst_tracker_get_target_markers(ctracker, name, marker_list)

    def pst_tracker_set_target_id(self, ctracker, name, id):
        return _c_pstsdk.pst_tracker_set_target_id(ctracker, name, id)

    def pst_tracker_set_reference(self, ctracker, creference, relative):
        return _c_pstsdk.pst_tracker_set_reference(ctracker, creference, relative)

    def pst_tracker_set_default_reference(self, ctracker):
        return _c_pstsdk.pst_tracker_set_default_reference(ctracker)

    def pst_tracker_get_reference(self, ctracker, creference):
        return _c_pstsdk.pst_tracker_get_reference(ctracker, creference)

    def pst_sdk_enable_shared_memory(self):
        return _c_pstsdk.pst_sdk_enable_shared_memory()

    def pst_sdk_disable_shared_memory(self):
        return _c_pstsdk.pst_sdk_disable_shared_memory()

    def pst_sdk_enable_rest_server(self, server_address, server_port, event_stream_retry_timeout):
        return _c_pstsdk.pst_sdk_enable_rest_server(server_address, server_port, event_stream_retry_timeout)

    def pst_sdk_disable_rest_server(self):
        return _c_pstsdk.pst_sdk_disable_rest_server()

    def pst_tracker_remove_target_model(self, ctracker, model_name):
        return _c_pstsdk.pst_tracker_remove_target_model(ctracker, model_name)

    def pst_camera_urls_init(self, urls):
        _c_pstsdk.pst_camera_urls_init(urls)

    def pst_camera_urls_destroy(self, urls):
        _c_pstsdk.pst_camera_urls_destroy(urls)

    def pst_trackerdata_init(self, trackerdata):
        _c_pstsdk.pst_trackerdata_init(trackerdata)

    def pst_trackerdata_destroy(self, trackerdata):
        _c_pstsdk.pst_trackerdata_destroy(trackerdata)

    def pst_image_init(self, image):
        _c_pstsdk.pst_image_init(image)

    def pst_image_destroy(self, image):
        _c_pstsdk.pst_image_destroy(image)

    def pst_target_markers_init(self, marker_list):
        _c_pstsdk.pst_target_markers_init(marker_list)

    def pst_target_markers_destroy(self, marker_list):
        _c_pstsdk.pst_target_markers_destroy(marker_list)

    def pst_sdk_get_version(self):
        _c_pstsdk.pst_sdk_get_version.restype = c.c_char_p
        return _c_pstsdk.pst_sdk_get_version()

    def pst_sdk_enable_logging(self):
        _c_pstsdk.pst_sdk_enable_logging()

    def pst_sdk_shutdown(self):
        _c_pstsdk.pst_sdk_shutdown()

    def pst_free(self, void_ptr):
        _c_pstsdk.pst_free(void_ptr)
        
    def pst_tracker_import_json_model(self, ctracker, json_model):
        return _c_pstsdk.pst_tracker_import_json_model(ctracker, json_model)
    
    def pst_tracker_export_json_model(self, ctracker, model_name, model_string):
        return _c_pstsdk.pst_tracker_export_json_model(ctracker, model_name, model_string)

##@endcond
