"""Module containing all point related classes and functions.

Copyright PS-Tech B.V. All Rights Reserved.
"""
import ctypes as c

class Point:
    """Estimated 3D marker location.

    This class contains information about individual 3D markers that have been detected by the PST Tracker
    but have not been estimated to be part of an active tracking target. As a single 3D point has no features
    to distinguish it from another, points are given an identifier based on their previous motion. Note that
    there is no guarantee that the identifier is consistent between sensor updates.

    Attributes:
        id: Marker identifier
        position: a tuple representing the 3D marker location

    See Also:
        trackerdata.TrackerData
    """
    def __init__(self, c_point):
        self.id = c_point.id
        self.position = (c_point.position[0],c_point.position[1],c_point.position[2])

    def __eq__(self, other):
        if not isinstance(other, Point):
            return NotImplemented
        return  self.id == other.id and self.position == other.position

    ##@cond
    class _CPoint(c.Structure):
        _fields_ = [
            ('id', c.c_int),
            ('position', c.c_float * 3),
        ]
    ##@endcond
