<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>examples.dox</name>
    <path>/home/pstech/builds/3SMsnoaN/0/ps-tech/pst-distributor/pstsdk/c/docs/</path>
    <filename>examples_8dox</filename>
  </compound>
  <compound kind="file">
    <name>main.dox</name>
    <path>/home/pstech/builds/3SMsnoaN/0/ps-tech/pst-distributor/pstsdk/c/docs/</path>
    <filename>main_8dox</filename>
  </compound>
  <compound kind="file">
    <name>usage.dox</name>
    <path>/home/pstech/builds/3SMsnoaN/0/ps-tech/pst-distributor/pstsdk/c/docs/</path>
    <filename>usage_8dox</filename>
  </compound>
  <compound kind="file">
    <name>pstsdk_c.h</name>
    <path>/home/pstech/builds/3SMsnoaN/0/ps-tech/pst-distributor/pstsdk/c/include/</path>
    <filename>pstsdk__c_8h</filename>
    <class kind="struct">PstImage</class>
    <class kind="struct">PstTarget</class>
    <class kind="struct">PstTargetStatus</class>
    <class kind="struct">PstPoint</class>
    <class kind="struct">PstTargetPose</class>
    <class kind="struct">PstTargetMarker</class>
    <class kind="struct">PstTargetMarkers</class>
    <class kind="struct">PstTrackerData</class>
    <class kind="struct">PstTracker</class>
    <class kind="struct">PstCameraURLs</class>
    <member kind="define">
      <type>#define</type>
      <name>PST_C_EXPORT</name>
      <anchorfile>pstsdk__c_8h.html</anchorfile>
      <anchor>a25d711685cdb3333b05c8fe0f8b9860e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EPstErrorStatus</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaeb8dc740c8ca041ee21958381e1c39fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_OK</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca453cc31c4f08d457f954d69976f1eb0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_TRACKER_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca530877b6d7acfb68e0f82ca1b78ce351</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NOT_INITIALIZED_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca00eb2150edb53d062bbd76461711b194</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NOT_SUPPORTED_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcac531738a06febc4e70fb0929e1885083</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_OUT_OF_RANGE_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca56840abfe4de992c06186c123e50dabe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NOT_FOUND_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca201c359de38b19ca2c4933927fd4b0fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_HTTP_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca727656ede9211a970d484265299fb5af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_FAILED_TO_ALLOCATE_MEMORY_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcad04240cc3681d1ea3b67344294f774c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NULLPTR_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca7650520e6ebf16e574fa7847fa4a3972</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_IMAGE_RETRIEVAL_FAILED_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca35abab0c7b0c7dc314e18fe77368b9ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_INVALID_DATA_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca7507e2167c997c390f7739163e23f3e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_ALREADY_EXISTS_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcac3009894592a10185f58c288e828c8bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_JSON_PARSING_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcabe920e1fa4b299eece9d511aef5075ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EPstStatusMessage</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga332374598b0d589a81f8defd5a186ed7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_OK</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a4d00fc3973967f8f587bcca6f97c1d0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_NOT_INITIALIZED</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a9df0921f1f3e6edc0dda72133e636eda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_DISCONNECTED</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a1edff9846465f1796430665d2aaff831</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_GENERAL</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7aa591c7f3de14ec9efd41aa7ef9937557</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_TIMEOUT</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7aba1aecc6de10da681f9047836ec7c965</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_NOCAMS_FOUND</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a8ceb273b2bdfcb2131361b56edf2f268</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_NOTENOUGHTCAMS_FOUND</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a591764839d09da0ad333dddd2022a0e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_INITERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a56ca0aeebb96c91c46cf706da7b4906f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_CANNOT_START_CAMS</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7aa9fdd5623d10c212ab961e108c05711e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_CANNOT_SETUP_CAMS</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7af71fd0157964b2a7e96e46c7e19ba1c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_NULL_TRACKER_HANDLE</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7af17abfa32548c310e071e21e7c9640c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_UNKNOWN_STATUS</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a83ae7a5dddb8dba3879478459d4a9428</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EPstTrackerMode</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga88101182fe0fb643e5ba44c606e0069a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_LOWPOWER</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa4827765cc14286fde8a6f1c228b60c9b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_SETUP</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aae9f77ac3d80d7b19e9ef231d26823abb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_TRACKING</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa5e3893f61e3ae44ce792afa9975de82a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_TRAINING</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa37f9b0f0d7bcbc7c9b77b3c093636b6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_DISCONNECT</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa515dcbf1c846fa417e9059907e44b89b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_RECONNECT</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aab441f46ab502471d1a107768462c3336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_UNKNOWN</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aaaaa90259c5ab7dd309289c4576f0cedd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_alloc_and_get_last_error_message</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga43b221281447524ba87d0cf964c1fb1a</anchor>
      <arglist>(char **cstring)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3ccbd4030e1635ed3cab198787f77100</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init1</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gae24fd32b6ae8adab6f565f7c49f25938</anchor>
      <arglist>(PstTracker *ctracker, const char path[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init2</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaefc6bab6f8f19102f45e5e0cd64950e6</anchor>
      <arglist>(PstTracker *ctracker, const char path[], const char config_file[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init3</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gae50d14ef5198bc2bc09de73950d8475d</anchor>
      <arglist>(PstTracker *ctracker, const char path[], const char config_file[], const char db_file[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init4</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga47615649043aa997ed4f91da34a5838f</anchor>
      <arglist>(PstTracker *ctracker, const char path[], const char config_file[], const char db_file[], const char grabber_name[])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_tracker_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga4ad5f09b509715992eaa5d318ebde5ec</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_load_calibration_from_local_path</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3fef9824b267a7c54d9141440e405863</anchor>
      <arglist>(const PstTracker *ctracker, const char path[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_connected_camera_urls</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaec7ceb445aad416c47f65d582deee2b4</anchor>
      <arglist>(const PstTracker *ctracker, bool silent, PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_uncalibrated_camera_urls</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gafc650240e251e3f7276663bf3c926e40</anchor>
      <arglist>(const PstTracker *ctracker, bool silent, PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_version_info</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga5fd003b6f43a24d0cc0aa1953a86f3b7</anchor>
      <arglist>(const PstTracker *ctracker, char **version_string)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_config_path</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga8c871260e53969a9a02ca25f81bfba42</anchor>
      <arglist>(const PstTracker *ctracker, char **config_path)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_single_measurement</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab49d952bbdded783e1c07ae606a5371c</anchor>
      <arglist>(const PstTracker *ctracker, PstTrackerData *cdata)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_add_tracker_data_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gadb63ca30a32c7c4ce33af0551a1c0934</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_add_tracker_mode_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab73edf075211cf7b93dce04bb8f9784e</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_add_tracker_callbacks</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gae128002f0875bde45618b47810006166</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus), void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_tracker_data_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga968580701a72fefaea55710ff24c03c3</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_tracker_mode_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga314104ed703d2be07f6f867473a0c958</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_tracker_callbacks</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga523dbd7c6cda507ede0e8b55295bf6d1</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus), void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_start</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga744ab9e0f85882c0a622405db0b9099c</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_pause</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga70ad295d454c87652a9231276a802857</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstStatusMessage</type>
      <name>pst_tracker_system_check</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gade17b6289195014229de0d1a2734a3dd</anchor>
      <arglist>(const PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_framerate</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga88ee969b69f130624359334a16118ca9</anchor>
      <arglist>(PstTracker *ctracker, double fps)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_framerate</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga38402abc69bffd1b0f78c3aedbe10abc</anchor>
      <arglist>(const PstTracker *ctracker, double *fps)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_supported_framerates</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab1f8abfe5ed5c26030bac476d331d841</anchor>
      <arglist>(const PstTracker *ctracker, float **framerates, size_t *number_of_framerates)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_exposure</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga38a6d443f51aa50aead2b8fd78b39080</anchor>
      <arglist>(PstTracker *ctracker, double time)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_exposure</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3e23d262e64c150352977437cc5b169b</anchor>
      <arglist>(const PstTracker *ctracker, double *exposure)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_exposure_range</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1a79587a3867ae8d43bdc33c44614f99</anchor>
      <arglist>(const PstTracker *ctracker, double *min, double *max)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_enable_filtering</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaa9d01e0776ae01cd24a4ea5d390ae94c</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_disable_filtering</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga2a0ed01b2ec3a9223b0e7f4ba7de4efa</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_position_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6833fd37468669f2614e56c6edeb6115</anchor>
      <arglist>(PstTracker *ctracker, double value)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_orientation_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga894861b3a62c3ea427a52a7dfcb55c8b</anchor>
      <arglist>(PstTracker *ctracker, double value)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_enable_tremor_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6d89e84bf0f75a73a41560b6e10d0100</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_disable_tremor_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab7525549d9da374840cef9ec008cd2be</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_enable_image_transfer</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gad1512500dc4c54c1e97b3ba01ecb5548</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_disable_image_transfer</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga94c9ccac0f21b07d1db1c43687ac70d9</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_pst_image</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga21d0129c82c26e2e7576f1602ea5ebf0</anchor>
      <arglist>(const PstTracker *ctracker, PstImage *image)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_target_list</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3a41dc2209c8d3163f4f75d61afbe62e</anchor>
      <arglist>(const PstTracker *ctracker, PstTargetStatus **statuses, size_t *number_of_statuses)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_target_info</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga10d23708f519732de1e58f14d559d050</anchor>
      <arglist>(const PstTracker *ctracker, const char *name, PstTarget *target)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_target_status</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6d1dfae84d18de93ac7c811c2fadc16a</anchor>
      <arglist>(PstTracker *ctracker, const char *name, bool set_active)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_target_status</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga221d996f85dac8b05238bee04bef94a3</anchor>
      <arglist>(const PstTracker *ctracker, const char *name, bool *status)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_target_markers</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3604cea54411ba5577edaf2cebefc0d0</anchor>
      <arglist>(const PstTracker *ctracker, const char *name, PstTargetMarkers *marker_list)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_target_id</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gacb1be0f53836f735acaccca8ceee56ce</anchor>
      <arglist>(PstTracker *ctracker, const char *name, int id)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_reference</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaebcb2e5c75ef2d946954f0be0a46f535</anchor>
      <arglist>(PstTracker *ctracker, const float creference[16], bool relative)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_default_reference</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga546b5fe253e4f758d17bafb2282f7a2a</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_reference</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab15f270cd83285ec92753646a6cc1a0c</anchor>
      <arglist>(const PstTracker *ctracker, float creference[16])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_sdk_enable_shared_memory</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gad5932cde1d443d4902c482dfa9b3041b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_disable_shared_memory</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga69b198e371f8ac8dd2caf7e66605c3ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_sdk_enable_rest_server</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gafa8ad2dc4cc9015ceb6cc62ac249fa99</anchor>
      <arglist>(const char *server_address, const char *server_port, int event_stream_retry_timeout)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_disable_rest_server</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga8800a577ef5a39e81f2db5f80cf1cd53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_target_model</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga128029d83bfe7c15473a8335d03a287f</anchor>
      <arglist>(PstTracker *ctracker, const char *model_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_camera_urls_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gacaf93dc6ef6b3b2b4fdb062c85976ac9</anchor>
      <arglist>(PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_camera_urls_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gad94cc5d2a06e3c334e576cb796b84587</anchor>
      <arglist>(PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_trackerdata_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1aaad6b87abff7bac712ab9721a10727</anchor>
      <arglist>(PstTrackerData *cdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_trackerdata_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga913cfe0fd5cc5a91a909f6f13f18f330</anchor>
      <arglist>(PstTrackerData *cdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_image_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1081d70ad5d79d9981192d6b8a527702</anchor>
      <arglist>(PstImage *image)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_image_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1289876ea85acf7449c996851ad57c9c</anchor>
      <arglist>(PstImage *image)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_target_markers_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga7fbc0ef8674b7032f621979e709a3602</anchor>
      <arglist>(PstTargetMarkers *marker_list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_target_markers_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga9fa5e6050e36df27f402c8ecec743c4a</anchor>
      <arglist>(PstTargetMarkers *marker_list)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>pst_sdk_get_version</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gac658a811ad6fb349ab93520fb653b51a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_enable_logging</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga81710f1816a4e7effc47c04a031a4e67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_shutdown</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga51cdfdd4b58044a84d0b9910db5ed169</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_free</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6dd1fff103f92f699b8d4b058cbfef3a</anchor>
      <arglist>(void *data)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_import_json_model</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaa0d4fe92d59fc31d9296e991969de083</anchor>
      <arglist>(const PstTracker *ctracker, const char *json_model)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_export_json_model</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga9fa3fcddec63427aed2963f1d7ae4816</anchor>
      <arglist>(const PstTracker *ctracker, const char *model_name, char **model_string)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>resource.h</name>
    <path>/home/pstech/builds/3SMsnoaN/0/ps-tech/pst-distributor/pstsdk/c/include/</path>
    <filename>resource_8h</filename>
  </compound>
  <compound kind="struct">
    <name>PstCameraURLs</name>
    <filename>struct_pst_camera_u_r_ls.html</filename>
    <member kind="variable">
      <type>char **</type>
      <name>url_data</name>
      <anchorfile>struct_pst_camera_u_r_ls.html</anchorfile>
      <anchor>af68012c166ff9ac2da9a5a0a3693201a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>number_of_urls</name>
      <anchorfile>struct_pst_camera_u_r_ls.html</anchorfile>
      <anchor>a3313a31f0f70c6e2dc599238b5846465</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstImage</name>
    <filename>struct_pst_image.html</filename>
    <member kind="variable">
      <type>size_t</type>
      <name>width</name>
      <anchorfile>struct_pst_image.html</anchorfile>
      <anchor>a4e3cd88e840c2b4ea0343011a1e103d6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>height</name>
      <anchorfile>struct_pst_image.html</anchorfile>
      <anchor>a5523fc6285a7989f3a66e98015a42909</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>number_of_images</name>
      <anchorfile>struct_pst_image.html</anchorfile>
      <anchor>adb8be22c7bfb6233103df198837ac303</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>unsigned char **</type>
      <name>images</name>
      <anchorfile>struct_pst_image.html</anchorfile>
      <anchor>a792199baeea5e5c1db2f53ad3f897e8a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstPoint</name>
    <filename>struct_pst_point.html</filename>
    <member kind="variable">
      <type>int</type>
      <name>id</name>
      <anchorfile>struct_pst_point.html</anchorfile>
      <anchor>a64ba94bd8a1b67f9a0021ec36a433ca2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>position</name>
      <anchorfile>struct_pst_point.html</anchorfile>
      <anchor>a64d2967b66364e7ce12e498d864ed9dc</anchor>
      <arglist>[3]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTarget</name>
    <filename>struct_pst_target.html</filename>
    <member kind="variable">
      <type>char</type>
      <name>name</name>
      <anchorfile>struct_pst_target.html</anchorfile>
      <anchor>a4e7d7cdff0d90c209176660cf3fdd4e0</anchor>
      <arglist>[128]</arglist>
    </member>
    <member kind="variable">
      <type>char</type>
      <name>uuid</name>
      <anchorfile>struct_pst_target.html</anchorfile>
      <anchor>a46e22355217fd101c5124bad51aaa858</anchor>
      <arglist>[37]</arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>id</name>
      <anchorfile>struct_pst_target.html</anchorfile>
      <anchor>ab0bd55effa66519933702885136afe0b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTargetMarker</name>
    <filename>struct_pst_target_marker.html</filename>
    <member kind="variable">
      <type>float</type>
      <name>coordinates</name>
      <anchorfile>struct_pst_target_marker.html</anchorfile>
      <anchor>aed422552460ab4e49bd6217e309aebf3</anchor>
      <arglist>[3]</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTargetMarkers</name>
    <filename>struct_pst_target_markers.html</filename>
    <member kind="variable">
      <type>PstTargetMarker *</type>
      <name>markers</name>
      <anchorfile>struct_pst_target_markers.html</anchorfile>
      <anchor>a73cfb802c0c3299bf9bcc3125c6d8dca</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>number_of_markers</name>
      <anchorfile>struct_pst_target_markers.html</anchorfile>
      <anchor>a29c86ee93e5ee8b902b3b771a84b8f8e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTargetPose</name>
    <filename>struct_pst_target_pose.html</filename>
    <member kind="variable">
      <type>PstTarget</type>
      <name>target</name>
      <anchorfile>struct_pst_target_pose.html</anchorfile>
      <anchor>a70b4ac298f0b38ec2865bf5a7dee8d1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>pose_matrix</name>
      <anchorfile>struct_pst_target_pose.html</anchorfile>
      <anchor>a3babe4c576b027811731b5b7c8b9b139</anchor>
      <arglist>[16]</arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>number_of_matched_points</name>
      <anchorfile>struct_pst_target_pose.html</anchorfile>
      <anchor>af48c3aa14aa16361c1815e178f6ccc01</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>PstPoint *</type>
      <name>matched_points</name>
      <anchorfile>struct_pst_target_pose.html</anchorfile>
      <anchor>a931b3c8dbf86693bd1db08c8248264c7</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTargetStatus</name>
    <filename>struct_pst_target_status.html</filename>
    <member kind="variable">
      <type>PstTarget</type>
      <name>target</name>
      <anchorfile>struct_pst_target_status.html</anchorfile>
      <anchor>ae9dd0a345eb3bf28b1241fc1a543c793</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>bool</type>
      <name>status</name>
      <anchorfile>struct_pst_target_status.html</anchorfile>
      <anchor>ac169f5a2cf4660b3d650e62a99116274</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTracker</name>
    <filename>struct_pst_tracker.html</filename>
    <member kind="variable">
      <type>void *</type>
      <name>tracker</name>
      <anchorfile>struct_pst_tracker.html</anchorfile>
      <anchor>ab64d6930f9f53affced249d087dfb15a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>PstTrackerData</name>
    <filename>struct_pst_tracker_data.html</filename>
    <member kind="variable">
      <type>double</type>
      <name>timestamp</name>
      <anchorfile>struct_pst_tracker_data.html</anchorfile>
      <anchor>aabc77e8796274f99ffe004a22cc9984c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>seqnumber</name>
      <anchorfile>struct_pst_tracker_data.html</anchorfile>
      <anchor>a56a85e3bee6cf5bcdbe9b039c5ea49c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>number_of_targets</name>
      <anchorfile>struct_pst_tracker_data.html</anchorfile>
      <anchor>a3b4dc91a7b87ad5d680473ba883cf28c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>size_t</type>
      <name>number_of_points</name>
      <anchorfile>struct_pst_tracker_data.html</anchorfile>
      <anchor>a5f3379ea4fcdd4b8a2663026ce5f15bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>PstTargetPose *</type>
      <name>targetlist</name>
      <anchorfile>struct_pst_tracker_data.html</anchorfile>
      <anchor>aa761e4b8c116f691995d2766c64a2412</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>PstPoint *</type>
      <name>datapoints</name>
      <anchorfile>struct_pst_tracker_data.html</anchorfile>
      <anchor>af647d0ba1fddb1242dbfe4c91d9c44f9</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>pstsdkc</name>
    <title>PST SDK C API</title>
    <filename>group__pstsdkc.html</filename>
    <class kind="struct">PstImage</class>
    <class kind="struct">PstTarget</class>
    <class kind="struct">PstTargetStatus</class>
    <class kind="struct">PstPoint</class>
    <class kind="struct">PstTargetPose</class>
    <class kind="struct">PstTargetMarker</class>
    <class kind="struct">PstTargetMarkers</class>
    <class kind="struct">PstTrackerData</class>
    <class kind="struct">PstTracker</class>
    <class kind="struct">PstCameraURLs</class>
    <member kind="enumeration">
      <type></type>
      <name>EPstErrorStatus</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaeb8dc740c8ca041ee21958381e1c39fc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_OK</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca453cc31c4f08d457f954d69976f1eb0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_TRACKER_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca530877b6d7acfb68e0f82ca1b78ce351</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NOT_INITIALIZED_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca00eb2150edb53d062bbd76461711b194</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NOT_SUPPORTED_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcac531738a06febc4e70fb0929e1885083</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_OUT_OF_RANGE_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca56840abfe4de992c06186c123e50dabe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NOT_FOUND_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca201c359de38b19ca2c4933927fd4b0fe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_HTTP_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca727656ede9211a970d484265299fb5af</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_FAILED_TO_ALLOCATE_MEMORY_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcad04240cc3681d1ea3b67344294f774c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_NULLPTR_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca7650520e6ebf16e574fa7847fa4a3972</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_IMAGE_RETRIEVAL_FAILED_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca35abab0c7b0c7dc314e18fe77368b9ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_INVALID_DATA_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fca7507e2167c997c390f7739163e23f3e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_ALREADY_EXISTS_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcac3009894592a10185f58c288e828c8bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_ERROR_STATUS_JSON_PARSING_ERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ggaeb8dc740c8ca041ee21958381e1c39fcabe920e1fa4b299eece9d511aef5075ba</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EPstStatusMessage</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga332374598b0d589a81f8defd5a186ed7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_OK</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a4d00fc3973967f8f587bcca6f97c1d0a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_NOT_INITIALIZED</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a9df0921f1f3e6edc0dda72133e636eda</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_DISCONNECTED</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a1edff9846465f1796430665d2aaff831</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_GENERAL</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7aa591c7f3de14ec9efd41aa7ef9937557</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_TIMEOUT</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7aba1aecc6de10da681f9047836ec7c965</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_NOCAMS_FOUND</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a8ceb273b2bdfcb2131361b56edf2f268</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_NOTENOUGHTCAMS_FOUND</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a591764839d09da0ad333dddd2022a0e6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_INITERROR</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a56ca0aeebb96c91c46cf706da7b4906f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_CANNOT_START_CAMS</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7aa9fdd5623d10c212ab961e108c05711e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_CANNOT_SETUP_CAMS</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7af71fd0157964b2a7e96e46c7e19ba1c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_NULL_TRACKER_HANDLE</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7af17abfa32548c310e071e21e7c9640c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_STATUSMESSAGE_ERR_UNKNOWN_STATUS</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga332374598b0d589a81f8defd5a186ed7a83ae7a5dddb8dba3879478459d4a9428</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>EPstTrackerMode</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga88101182fe0fb643e5ba44c606e0069a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_LOWPOWER</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa4827765cc14286fde8a6f1c228b60c9b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_SETUP</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aae9f77ac3d80d7b19e9ef231d26823abb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_TRACKING</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa5e3893f61e3ae44ce792afa9975de82a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_TRAINING</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa37f9b0f0d7bcbc7c9b77b3c093636b6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_DISCONNECT</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aa515dcbf1c846fa417e9059907e44b89b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_RECONNECT</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aab441f46ab502471d1a107768462c3336</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <name>PST_MODE_UNKNOWN</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gga88101182fe0fb643e5ba44c606e0069aaaaa90259c5ab7dd309289c4576f0cedd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_alloc_and_get_last_error_message</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga43b221281447524ba87d0cf964c1fb1a</anchor>
      <arglist>(char **cstring)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3ccbd4030e1635ed3cab198787f77100</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init1</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gae24fd32b6ae8adab6f565f7c49f25938</anchor>
      <arglist>(PstTracker *ctracker, const char path[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init2</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaefc6bab6f8f19102f45e5e0cd64950e6</anchor>
      <arglist>(PstTracker *ctracker, const char path[], const char config_file[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init3</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gae50d14ef5198bc2bc09de73950d8475d</anchor>
      <arglist>(PstTracker *ctracker, const char path[], const char config_file[], const char db_file[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_init4</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga47615649043aa997ed4f91da34a5838f</anchor>
      <arglist>(PstTracker *ctracker, const char path[], const char config_file[], const char db_file[], const char grabber_name[])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_tracker_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga4ad5f09b509715992eaa5d318ebde5ec</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_load_calibration_from_local_path</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3fef9824b267a7c54d9141440e405863</anchor>
      <arglist>(const PstTracker *ctracker, const char path[])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_connected_camera_urls</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaec7ceb445aad416c47f65d582deee2b4</anchor>
      <arglist>(const PstTracker *ctracker, bool silent, PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_uncalibrated_camera_urls</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gafc650240e251e3f7276663bf3c926e40</anchor>
      <arglist>(const PstTracker *ctracker, bool silent, PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_version_info</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga5fd003b6f43a24d0cc0aa1953a86f3b7</anchor>
      <arglist>(const PstTracker *ctracker, char **version_string)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_config_path</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga8c871260e53969a9a02ca25f81bfba42</anchor>
      <arglist>(const PstTracker *ctracker, char **config_path)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_single_measurement</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab49d952bbdded783e1c07ae606a5371c</anchor>
      <arglist>(const PstTracker *ctracker, PstTrackerData *cdata)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_add_tracker_data_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gadb63ca30a32c7c4ce33af0551a1c0934</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_add_tracker_mode_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab73edf075211cf7b93dce04bb8f9784e</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_add_tracker_callbacks</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gae128002f0875bde45618b47810006166</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus), void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_tracker_data_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga968580701a72fefaea55710ff24c03c3</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_tracker_mode_callback</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga314104ed703d2be07f6f867473a0c958</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_tracker_callbacks</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga523dbd7c6cda507ede0e8b55295bf6d1</anchor>
      <arglist>(PstTracker *ctracker, void(*on_tracker_data)(const PstTrackerData *, EPstErrorStatus), void(*on_tracker_mode)(EPstTrackerMode))</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_start</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga744ab9e0f85882c0a622405db0b9099c</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_pause</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga70ad295d454c87652a9231276a802857</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstStatusMessage</type>
      <name>pst_tracker_system_check</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gade17b6289195014229de0d1a2734a3dd</anchor>
      <arglist>(const PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_framerate</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga88ee969b69f130624359334a16118ca9</anchor>
      <arglist>(PstTracker *ctracker, double fps)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_framerate</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga38402abc69bffd1b0f78c3aedbe10abc</anchor>
      <arglist>(const PstTracker *ctracker, double *fps)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_supported_framerates</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab1f8abfe5ed5c26030bac476d331d841</anchor>
      <arglist>(const PstTracker *ctracker, float **framerates, size_t *number_of_framerates)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_exposure</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga38a6d443f51aa50aead2b8fd78b39080</anchor>
      <arglist>(PstTracker *ctracker, double time)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_exposure</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3e23d262e64c150352977437cc5b169b</anchor>
      <arglist>(const PstTracker *ctracker, double *exposure)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_exposure_range</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1a79587a3867ae8d43bdc33c44614f99</anchor>
      <arglist>(const PstTracker *ctracker, double *min, double *max)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_enable_filtering</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaa9d01e0776ae01cd24a4ea5d390ae94c</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_disable_filtering</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga2a0ed01b2ec3a9223b0e7f4ba7de4efa</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_position_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6833fd37468669f2614e56c6edeb6115</anchor>
      <arglist>(PstTracker *ctracker, double value)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_orientation_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga894861b3a62c3ea427a52a7dfcb55c8b</anchor>
      <arglist>(PstTracker *ctracker, double value)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_enable_tremor_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6d89e84bf0f75a73a41560b6e10d0100</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_disable_tremor_filter</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab7525549d9da374840cef9ec008cd2be</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_enable_image_transfer</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gad1512500dc4c54c1e97b3ba01ecb5548</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_disable_image_transfer</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga94c9ccac0f21b07d1db1c43687ac70d9</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_pst_image</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga21d0129c82c26e2e7576f1602ea5ebf0</anchor>
      <arglist>(const PstTracker *ctracker, PstImage *image)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_alloc_and_get_target_list</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3a41dc2209c8d3163f4f75d61afbe62e</anchor>
      <arglist>(const PstTracker *ctracker, PstTargetStatus **statuses, size_t *number_of_statuses)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_target_info</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga10d23708f519732de1e58f14d559d050</anchor>
      <arglist>(const PstTracker *ctracker, const char *name, PstTarget *target)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_target_status</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6d1dfae84d18de93ac7c811c2fadc16a</anchor>
      <arglist>(PstTracker *ctracker, const char *name, bool set_active)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_target_status</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga221d996f85dac8b05238bee04bef94a3</anchor>
      <arglist>(const PstTracker *ctracker, const char *name, bool *status)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_target_markers</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga3604cea54411ba5577edaf2cebefc0d0</anchor>
      <arglist>(const PstTracker *ctracker, const char *name, PstTargetMarkers *marker_list)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_target_id</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gacb1be0f53836f735acaccca8ceee56ce</anchor>
      <arglist>(PstTracker *ctracker, const char *name, int id)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_reference</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaebcb2e5c75ef2d946954f0be0a46f535</anchor>
      <arglist>(PstTracker *ctracker, const float creference[16], bool relative)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_set_default_reference</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga546b5fe253e4f758d17bafb2282f7a2a</anchor>
      <arglist>(PstTracker *ctracker)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_get_reference</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gab15f270cd83285ec92753646a6cc1a0c</anchor>
      <arglist>(const PstTracker *ctracker, float creference[16])</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_sdk_enable_shared_memory</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gad5932cde1d443d4902c482dfa9b3041b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_disable_shared_memory</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga69b198e371f8ac8dd2caf7e66605c3ee</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_sdk_enable_rest_server</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gafa8ad2dc4cc9015ceb6cc62ac249fa99</anchor>
      <arglist>(const char *server_address, const char *server_port, int event_stream_retry_timeout)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_disable_rest_server</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga8800a577ef5a39e81f2db5f80cf1cd53</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_remove_target_model</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga128029d83bfe7c15473a8335d03a287f</anchor>
      <arglist>(PstTracker *ctracker, const char *model_name)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_camera_urls_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gacaf93dc6ef6b3b2b4fdb062c85976ac9</anchor>
      <arglist>(PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_camera_urls_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gad94cc5d2a06e3c334e576cb796b84587</anchor>
      <arglist>(PstCameraURLs *urls)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_trackerdata_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1aaad6b87abff7bac712ab9721a10727</anchor>
      <arglist>(PstTrackerData *cdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_trackerdata_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga913cfe0fd5cc5a91a909f6f13f18f330</anchor>
      <arglist>(PstTrackerData *cdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_image_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1081d70ad5d79d9981192d6b8a527702</anchor>
      <arglist>(PstImage *image)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_image_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga1289876ea85acf7449c996851ad57c9c</anchor>
      <arglist>(PstImage *image)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_target_markers_init</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga7fbc0ef8674b7032f621979e709a3602</anchor>
      <arglist>(PstTargetMarkers *marker_list)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_target_markers_destroy</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga9fa5e6050e36df27f402c8ecec743c4a</anchor>
      <arglist>(PstTargetMarkers *marker_list)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>pst_sdk_get_version</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gac658a811ad6fb349ab93520fb653b51a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_enable_logging</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga81710f1816a4e7effc47c04a031a4e67</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_sdk_shutdown</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga51cdfdd4b58044a84d0b9910db5ed169</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pst_free</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga6dd1fff103f92f699b8d4b058cbfef3a</anchor>
      <arglist>(void *data)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_import_json_model</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>gaa0d4fe92d59fc31d9296e991969de083</anchor>
      <arglist>(const PstTracker *ctracker, const char *json_model)</arglist>
    </member>
    <member kind="function">
      <type>EPstErrorStatus</type>
      <name>pst_tracker_export_json_model</name>
      <anchorfile>group__pstsdkc.html</anchorfile>
      <anchor>ga9fa3fcddec63427aed2963f1d7ae4816</anchor>
      <arglist>(const PstTracker *ctracker, const char *model_name, char **model_string)</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>Using_SDK_c</name>
    <title>Using PST SDK</title>
    <filename>_using__s_d_k_c</filename>
    <docanchor file="_using__s_d_k_c" title="Setup Windows">Setup_win_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Setup Linux">Setup_linux_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Error Handling">Exceptions_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Initialization">Initialization_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Calibration">Calibration_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Tracking Target Setup">Target_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Usage">Usage_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Receiving tracker data">Receive_data_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Filtering">Filtering_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Camera Images">Images_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Reference System">Reference_c</docanchor>
    <docanchor file="_using__s_d_k_c" title="Safe Tracker Termination">Termination_c</docanchor>
  </compound>
  <compound kind="page">
    <name>Examples_c</name>
    <title>Examples</title>
    <filename>_examples_c</filename>
  </compound>
  <compound kind="page">
    <name>listener_c</name>
    <title>listener.c</title>
    <filename>listener_c</filename>
  </compound>
  <compound kind="page">
    <name>minimal_c</name>
    <title>minimal.c</title>
    <filename>minimal_c</filename>
  </compound>
  <compound kind="page">
    <name>sharedmemory_c</name>
    <title>sharedmemory.c</title>
    <filename>sharedmemory_c</filename>
  </compound>
  <compound kind="page">
    <name>trackingtarget_c</name>
    <title>trackingtarget.c</title>
    <filename>trackingtarget_c</filename>
  </compound>
  <compound kind="page">
    <name>exposure_c</name>
    <title>exposure.c</title>
    <filename>exposure_c</filename>
  </compound>
  <compound kind="page">
    <name>reference_c</name>
    <title>reference.c</title>
    <filename>reference_c</filename>
  </compound>
  <compound kind="page">
    <name>images_c</name>
    <title>images.c</title>
    <filename>images_c</filename>
  </compound>
  <compound kind="page">
    <name>restserver_c</name>
    <title>restserver.c</title>
    <filename>restserver_c</filename>
  </compound>
  <compound kind="page">
    <name>index</name>
    <title>Using C</title>
    <filename>index</filename>
    <docanchor file="index">c_module</docanchor>
    <docanchor file="index" title="Requirements">Requirements_c</docanchor>
    <docanchor file="index" title="Topics">Topics_c</docanchor>
  </compound>
</tagfile>
